<?php

namespace Yoast\WP\SEO\Premium\Integrations\Third_Party;

use WP_Post;
use WPSEO_Admin_Utils;
use Yoast\WP\SEO\Integrations\Integration_Interface;
use Yoast\WP\SEO\Premium\Conditionals\Zapier_Enabled_Conditional;
use Yoast\WP\SEO\Premium\Helpers\Zapier_Helper;

/**
 * Class to manage the Zapier integration in the Classic editor.
 */
class Zapier_Classic_Editor implements Integration_Interface {

	/**
	 * The Zapier helper.
	 *
	 * @var Zapier_Helper
	 */
	protected $zapier_helper;

	/**
	 * Zapier constructor.
	 *
	 * @param Zapier_Helper $zapier_helper The Zapier helper.
	 */
	public function __construct( Zapier_Helper $zapier_helper ) {
		$this->zapier_helper = $zapier_helper;
	}

	/**
	 * Returns the conditionals based in which this loadable should be active.
	 *
	 * @return array
	 */
	public static function get_conditionals() {
		return [ Zapier_Enabled_Conditional::class ];
	}

	/**
	 * Initializes the integration.
	 *
	 * This is the place to register hooks and filters.
	 *
	 * @return void
	 */
	public function register_hooks() {
		\add_action( 'wpseo_publishbox_misc_actions', [ $this, 'add_publishbox_text' ] );
	}

	/**
	 * Adds the Zapier text to the Classic Editor publish box.
	 *
	 * @param WP_Post $post The current post object.
	 *
	 * @return void
	 */
	public function add_publishbox_text( WP_Post $post ) {
		if ( ! $this->zapier_helper->is_post_type_supported( $post->post_type )
			|| $this->zapier_helper->is_connected() ) {
			return;
		}
		?>
		<div class="misc-pub-section yoast yoast-zapier-text">
			<svg class="yoast-zapier-text__icon" role="img" aria-hidden="true" focusable="false" width="2500" height="2500" viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg"><path d="M159.999 128.056a76.55 76.55 0 0 1-4.915 27.024 76.745 76.745 0 0 1-27.032 4.923h-.108c-9.508-.012-18.618-1.75-27.024-4.919A76.557 76.557 0 0 1 96 128.056v-.112a76.598 76.598 0 0 1 4.91-27.02A76.492 76.492 0 0 1 127.945 96h.108a76.475 76.475 0 0 1 27.032 4.923 76.51 76.51 0 0 1 4.915 27.02v.112zm94.223-21.389h-74.716l52.829-52.833a128.518 128.518 0 0 0-13.828-16.349v-.004a129 129 0 0 0-16.345-13.816l-52.833 52.833V1.782A128.606 128.606 0 0 0 128.064 0h-.132c-7.248.004-14.347.62-21.265 1.782v74.716L53.834 23.665A127.82 127.82 0 0 0 37.497 37.49l-.028.02A128.803 128.803 0 0 0 23.66 53.834l52.837 52.833H1.782S0 120.7 0 127.956v.088c0 7.256.615 14.367 1.782 21.289h74.716l-52.837 52.833a128.91 128.91 0 0 0 30.173 30.173l52.833-52.837v74.72a129.3 129.3 0 0 0 21.24 1.778h.181a129.15 129.15 0 0 0 21.24-1.778v-74.72l52.838 52.837a128.994 128.994 0 0 0 16.341-13.82l.012-.012a129.245 129.245 0 0 0 13.816-16.341l-52.837-52.833h74.724c1.163-6.91 1.77-14 1.778-21.24v-.186c-.008-7.24-.615-14.33-1.778-21.24z" fill="#FF4A00"/></svg>
			<span>
			<?php
			\printf(
				/* translators: 1: Link start tag, 2: Yoast SEO, 3: Zapier, 4: Link closing tag. */
				\esc_html__( '%1$sConnect %2$s with %3$s%4$s to instantly share your published posts with 2000+ destinations such as Twitter, Facebook and more.', 'wordpress-seo-premium' ),
				'<a href="' . \esc_url( \admin_url( 'admin.php?page=wpseo_dashboard#top#integrations' ) ) . '" target="_blank">',
				'Yoast SEO',
				'Zapier',
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- The content is already escaped.
				WPSEO_Admin_Utils::get_new_tab_message() . '</a>'
			);
			?>
			</span>
		</div>
		<?php
	}
}
