<?php
/**
 * @package drclubs
 */

namespace DrClubs\Api\Tables;


use DrClubs\Base\BusinessController;
use WP_List_Table;

class LogsTable extends WP_List_Table
{


    function __construct()
    {
        parent::__construct(array(
            'singular' => 'log', //Singular label
            'plural' => 'logs', //plural label, also this well be one of the table css class
            'ajax' => true //We won't support Ajax for this table
        ));
    }

    function extra_tablenav($which)
    {
        if ($which == "top") {
            //The code that goes before the table is here
            echo "<h3 style='font-family: Tanha,serif' class='text-right'>رویداد های ثبت شده</h3>";
        }
        if ($which == "bottom") {
            //The code that goes after the table is there
            echo "";
        }
    }

    function get_columns()
    {
        return $columns = array(
            'col_customers_success' => wp_strip_all_tags(__('ثبت مشتری موفق')),
            'col_customers_fail' => wp_strip_all_tags(__('ثبت مشتری ناموفق')),
            'col_transactions_success' => wp_strip_all_tags(__('برداشت کیف پول موفق')),
            'col_transactions_fail' => wp_strip_all_tags(__('برداشت کیف پول ناموفق')),
            'col_response_percent' => wp_strip_all_tags(__('درصد پاسخ سرور'))
        );
    }

    public function get_sortable_columns()
    {
        return $sortable = array(//            'col_link_id' => 'link_id',

        );
    }

    /**
     * @return array
     */
    public function getColumnHeaders()
    {
        return $this->_column_headers;
    }

    public function print_column_headers($with_id = true)
    {
        parent::print_column_headers($with_id); // TODO: Change the autogenerated stub
    }

    /**
     * Prepare the table with different parameters, pagination, columns and table elements
     */
    function prepare_items()
    {
        global $wpdb, $_wp_column_headers;
        $screen = get_current_screen();


        $totalitems = 1;

        $perpage = 1;

        $totalpages = ceil($totalitems / $perpage);
        //adjust the query to take pagination into account


        $this->set_pagination_args(array(
            "total_items" => $totalitems,
            "total_pages" => $totalpages,
            "per_page" => $perpage,
        ));
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = array();
        $primary = 'name';

        $this->_column_headers = array($columns, $hidden, $sortable, $primary);
        /* -- Fetch the items -- */
        $this->items = [get_option(BusinessController::$logs_option_group, BusinessController::LOGS_DEFAULT)];
    }

    protected function display_tablenav($which)
    {
        ?>
        <div class="tablenav <?php echo esc_attr($which); ?>">

            <div class="alignleft actions bulkactions">
                <?php $this->bulk_actions($which); ?>
            </div>
            <?php
            $this->extra_tablenav($which);
            $this->pagination($which);

            ?>

            <br class="clear"/>
        </div>
        <?php
    }

    /**
     * Display the rows of records in the table
     * @return string, echo the markup of the rows
     */
    function display_rows()
    {

        //Get the records registered in the prepare_items method
        $records = $this->items;

        //Get the columns registered in the get_columns and get_sortable_columns methods
//        list($columns, $hidden, $sortable, $primary) = $this->get_column_info();
        $hidden = [];
        $columns = $this->get_columns();

        //Loop for each record
        if (!empty($records)) {
            foreach ($records as $idx => $rec) {
                //Open the line
                echo '<tr id="record_' . ($idx + 1) . '">';

                foreach ($columns as $column_name => $column_display_name) {

                    //Style attributes for each col
                    $class = "class='$column_name column-$column_name'";
                    $style = " style='text-align:center;' ";
                    if (in_array($column_name, $hidden)) $style = ' style="display:none;"';
                    $attributes = $class . $style;

                    //edit link
                    $editlink = '/wp-admin/link.php?action=edit&link_id=' . (int)$rec->link_id;

                    $total_responses = $rec['customers']['success'] + $rec['customers']['fail'] + $rec['transactions']['success'] + $rec['transactions']['fail'];
                    $total_success = $rec['customers']['success'] + $rec['transactions']['success'];
                    //Display the cell

                    switch ($column_name) {
                        case "col_customers_success":
                            echo '<td ' . $attributes . '>' . $rec['customers']['success'] . '</td>';
                            break;
                        case "col_customers_fail":
                            echo '<td ' . $attributes . '>' . $rec['customers']['fail'] . '</td>';
                            break;
                        case "col_transactions_success":
                            echo '<td ' . $attributes . '>' . $rec['transactions']['success'] . '</td>';
                            break;
                        case "col_transactions_fail":
                            echo '<td ' . $attributes . '>' . $rec['transactions']['fail'] . '</td>';
                            break;
                        case "col_response_percent":
                            echo '<td ' . $attributes . '>' . ($total_responses == 0 ? '0' : floor($total_success * 100 / $total_responses)) . '%' . '</td>';
                            break;
                    }
                }

                //Close the line
                echo '</tr>';
            }
        }
    }

    public function single_row($item)
    {
        echo '<tr>';
        $this->single_row_columns($item);
        echo '</tr>';
    }
}