<?php
/**
 * @package drclubs
 */

namespace DrClubs\Api\Tables;


use DrClubs\Api\DrClubsApi;
use DrClubs\Base\UserController;
use function DrClubs\get_timezone_offset;
use Tightenco\Collect\Support\Collection;
use WP_List_Table;

class TransactionsTable extends WP_List_Table
{
    public $columns = [];
    public $drClubsAPI;

    function __construct()
    {
        parent::__construct(array(
            'singular' => 'تراکنش', //Singular label
            'plural' => 'تراکنش ها', //plural label, also this well be one of the table css class
            'ajax' => false //We won't support Ajax for this table
        ));
        add_action('admin_head', function () {
            echo '<style type="text/css">
           .wp-list-table   { overflow-x: scroll; }

             </style>';
        });

        $this->drClubsAPI = new DrClubsApi();

    }

    function extra_tablenav($which)
    {
        if ($which == "top") {
            //The code that goes before the table is here
            echo "";
        }
        if ($which == "bottom") {
            //The code that goes after the table is there
            echo "";
        }
    }

    function column_default($item, $column_name)
    {

        if ($column_name == 'edit_delete') {
            return '<a href="/wp-admin/?page=bsog_events_registrations_delete&event_registration_id=' . $item['id'] . '&event_id=' . $_GET['event_id'] . '">Delete</a> | <a href="/wp-admin/?page=bsog_events_registrations_update&event_registration_id=' . $item['id'] . '&event_id=' . $_GET['event_id'] . '">Edit</a>';
        } else {
            return $item[$column_name];
        }
    }

    public function display()
    {

        $singular = $this->_args['singular'];

        $this->display_tablenav('top');

        $this->screen->render_screen_reader_content('heading_list');
        ?>
        <table class="wp-list-table   <?php echo implode(' ', $this->get_table_classes()); ?>">
            <thead>
            <tr>
                <?php $this->print_column_headers(); ?>
            </tr>
            </thead>

            <tbody id="the-list"
                <?php
                if ($singular) {
                    echo " data-wp-lists='list:$singular'";
                }
                ?>
            >
            <?php $this->display_rows_or_placeholder(); ?>
            </tbody>

            <tfoot>

            </tfoot>

        </table>
        <?php
        $this->display_tablenav('bottom');
    }

    function get_columns()
    {
        return $columns = array(
//            'col_id' => 'شناسه کاربری',
            'col_amount' => 'مبلیغ خرید(ریال)',
            'col_balance' => 'برداشت از کیف پول',
            'col_score' => 'امتیاز',
            'col_dateTime' => 'تاریخ ثبت',

        );
    }

    public function get_sortable_columns()
    {
        return $sortable = array(
            'col_amount' => ['amount', false],
            'col_balance' => ['balance', false],
            'col_dateTime' => ['dateTime', false],
        );
    }

    protected function get_primary_column_name()
    {
        return null;
    }

    /**
     * Prepare the table with different parameters, pagination, columns and table elements
     */
    public function print_column_headers($with_id = true)
    {
        parent::print_column_headers($with_id); // TODO: Change the autogenerated stub
    }

    function prepare_items()
    {
        global $wpdb, $_wp_column_headers;
        $screen = get_current_screen();

        /* -- Preparing your query -- */
        $data = new Collection($this->drClubsAPI->getLastTransactions('BUSINESS'));

        /* -- Ordering parameters -- */
        //Parameters that are going to be used to order the result
        $orderby = !empty($_GET["orderby"]) ? esc_sql($_GET["orderby"]) : 'user_id';
        $order = !empty($_GET["order"]) ? esc_sql($_GET["order"]) : 'asc';
        if (in_array("col_$orderby", array_keys($this->get_columns())))
            $data = $data->sortBy($orderby, null, $order != 'asc');

        /* -- Pagination parameters -- */
        //Number of elements in your table?
        $totalitems = $data->count(); //return the total number of affected rows

        //How many to display per page?
        $perpage = 24;
        //Which page is this?
        $paged = !empty($_GET["paged"]) ? esc_sql($_GET["paged"]) : null;
        //Page Number
        if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
            $paged = 1;
        } //How many pages do we have in total?
        $totalpages = ceil($totalitems / $perpage);
        //adjust the query to take pagination into account

        /* -- Register the pagination -- */
        $this->set_pagination_args(array(
            "total_items" => $totalitems,
            "total_pages" => $totalpages,
            "per_page" => $perpage,
            'orderby' => !empty($_REQUEST['orderby']) && '' != $_REQUEST['orderby'] ? $_REQUEST['orderby'] : 'user_id',
            'order' => !empty($_REQUEST['order']) && '' != $_REQUEST['order'] ? $_REQUEST['order'] : 'asc'

        ));
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $this->columns = [
            $this->get_columns(),
            [], // hidden columns
            $this->get_sortable_columns(),
            $this->get_primary_column_name(),
        ];
        $_wp_column_headers[$screen->id] = $this->columns;
        $this->_column_headers = $this->columns;

        /* -- Fetch the items -- */
        $this->items = $data->all();

    }

    /**
     * Display the rows of records in the table
     * @return string, echo the markup of the rows
     */
    function display_rows()
    {

        //Get the records registered in the prepare_items method
        $records = $this->items;
        list($columns, $hidden, $sortable, $primary) = $this->columns;
        //Get the columns registered in the get_columns and get_sortable_columns methods
        $empty_sign = '<span class="dashicons dashicons-minus"></span>';
        //Loop for each record
        if (!empty($records)) {
            foreach ($records as $idx => $data) {
                $user_id = $data->id;


                //Open the line
                echo '<tr id="record_' . $user_id . '">';
                foreach ($columns as $column_name => $column_display_name) {

                    //Style attributes for each col
                    $class = "class='$column_name column-$column_name'";
                    $style = "";
                    if (in_array($column_name, $hidden)) $style = ' style="display:none;"';
                    $attributes = $class . $style;

                    //edit link


                    //Display the cell
                    switch ($column_name) {
//                        case "col_id":
//                            echo '<td ' . $attributes . '>' . stripslashes(isset($user_id) ? $user_id : $empty_sign) . '</td>';
//                            break;
                        case "col_amount":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->amount) ? $data->amount : $empty_sign) . '</td>';
                            break;
                        case "col_balance":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->balance) ? -$data->balance : $empty_sign) . '</td>';
                            break;
                        case "col_score":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->score) ? $data->score : $empty_sign) . '</td>';
                            break;
                        case "col_dateTime":

                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->dateTime) ? date_i18n('F d, Y H:i', (new \DateTime($data->dateTime))->getTimestamp()) : $empty_sign) . '</td>';
                            break;

                    }
                }

                //Close the line
                echo '</tr>';
            }
        }
    }
}