<?php
/**
 * @package drclubs
 */

namespace DrClubs\Api\Tables;


use DrClubs\Base\UserController;
use WP_List_Table;

class UsersTable extends WP_List_Table
{
    public $columns = [];

    function __construct()
    {
        parent::__construct(array(
            'singular' => 'کاربر', //Singular label
            'plural' => 'کاربران', //plural label, also this well be one of the table css class
            'ajax' => false //We won't support Ajax for this table
        ));
        add_action('admin_head', function () {
            echo '<style type="text/css">
           .wp-list-table   { overflow-x: scroll; }

             </style>';
        });
    }

    function extra_tablenav($which)
    {
        if ($which == "top") {
            //The code that goes before the table is here
            echo "";
        }
        if ($which == "bottom") {
            //The code that goes after the table is there
            echo "";
        }
    }

    function column_default($item, $column_name)
    {

        if ($column_name == 'edit_delete') {
            return '<a href="/wp-admin/?page=bsog_events_registrations_delete&event_registration_id=' . $item['id'] . '&event_id=' . $_GET['event_id'] . '">Delete</a> | <a href="/wp-admin/?page=bsog_events_registrations_update&event_registration_id=' . $item['id'] . '&event_id=' . $_GET['event_id'] . '">Edit</a>';
        } else {
            return $item[$column_name];
        }
    }

    public function display()
    {

        $singular = $this->_args['singular'];

        $this->display_tablenav('top');

        $this->screen->render_screen_reader_content('heading_list');
        ?>
        <table class="wp-list-table   <?php echo implode(' ', $this->get_table_classes()); ?>">
            <thead>
            <tr>
                <?php $this->print_column_headers(); ?>
            </tr>
            </thead>

            <tbody id="the-list"
                <?php
                if ($singular) {
                    echo " data-wp-lists='list:$singular'";
                }
                ?>
            >
            <?php $this->display_rows_or_placeholder(); ?>
            </tbody>

            <tfoot>

            </tfoot>

        </table>
        <?php
        $this->display_tablenav('bottom');
    }

    function get_columns()
    {
        return $columns = array(
            'col_user_id' => 'شناسه کاربری',
//            'col_Id' => 'شناسه دکتر کلابز',
            'col_Fname' => 'نام',
            'col_Lname' => 'نام خانوادگی',
            'col_NationalCode' => 'کد ملی',
            'col_Gender' => 'جنسیت',
            'col_BornDate' => 'تاریخ تولد',
            'col_PhoneNumber' => 'شماره تماس',
            'col_CardNumber' => 'شماره کارت',
            'col_score' => 'امتیاز',
            'col_purchaseVolume' => 'خرید (تومان)',
//            'col_Actions' => 'عملیات',
            'col_Enabled' => 'وضعیت',
        );
    }

    public function get_sortable_columns()
    {
        return $sortable = array(
            'col_user_id' => ['user_id', false],
            'col_Fname' => ['Fname', false],
            'col_Lname' => ['Lname', false],
            'col_NationalCode' => ['NationalCode', false],
            'col_Gender' => ['Gender', false],
            'col_BornDate' => ['BornDate', false],
            'col_PhoneNumber' => ['PhoneNumber', false],
            'col_CardNumber' => ['CardNumber', false],
            'col_Enabled' => ['Enabled', false],
            'col_score' => ['score', false],
            'col_purchaseVolume' => ['purchaseVolume', false],

        );
    }

    protected function get_primary_column_name()
    {
        return null;
    }

    /**
     * Prepare the table with different parameters, pagination, columns and table elements
     */
    public function print_column_headers($with_id = true)
    {
        parent::print_column_headers($with_id); // TODO: Change the autogenerated stub
    }

    function prepare_items()
    {
        global $wpdb, $_wp_column_headers;
        $screen = get_current_screen();

        /* -- Preparing your query -- */
        $query = "SELECT `user_id`,`meta_value` FROM $wpdb->usermeta WHERE `meta_key` = '" . UserController::USER_META_KEY . "'";

        $query = "SELECT `user_id`,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.Id')) As Id  ,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.Fname')) As Fname,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.Lname')) As Lname,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.NationalCode')) As NationalCode,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.Gender')) As Gender,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.BornDate')) As BornDate,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.PhoneNumber')) As PhoneNumber,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.CardNumber')) As CardNumber,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.score')) As score,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.purchaseVolume')) As purchaseVolume,
  JSON_UNQUOTE(JSON_EXTRACT(meta_value,'$.Enabled')) As Enabled
   FROM $wpdb->usermeta WHERE `meta_key` = '" . UserController::USER_META_KEY . "'";

        /* -- Ordering parameters -- */
        //Parameters that are going to be used to order the result
        $orderby = !empty($_GET["orderby"]) ? esc_sql($_GET["orderby"]) : 'user_id';
        $order = !empty($_GET["order"]) ? esc_sql($_GET["order"]) : 'asc';
        if (!empty($orderby) & !empty($order) && in_array("col_$orderby", array_keys($this->get_columns()))) {
            $query .= ' ORDER BY ' . $orderby . ' ' . $order;
        }

        /* -- Pagination parameters -- */
        //Number of elements in your table?
        $totalitems = $wpdb->query($query); //return the total number of affected rows

        //How many to display per page?
        $perpage = 24;
        //Which page is this?
        $paged = !empty($_GET["paged"]) ? esc_sql($_GET["paged"]) : null;
        //Page Number
        if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
            $paged = 1;
        } //How many pages do we have in total?
        $totalpages = ceil($totalitems / $perpage);
        //adjust the query to take pagination into account
        if (!empty($paged) && !empty($perpage)) {
            $offset = ($paged - 1) * $perpage;
            $query .= ' LIMIT ' . (int)$offset . ',' . (int)$perpage;
        }
        /* -- Register the pagination -- */
        $this->set_pagination_args(array(
            "total_items" => $totalitems,
            "total_pages" => $totalpages,
            "per_page" => $perpage,
            'orderby' => !empty($_REQUEST['orderby']) && '' != $_REQUEST['orderby'] ? $_REQUEST['orderby'] : 'user_id',
            'order' => !empty($_REQUEST['order']) && '' != $_REQUEST['order'] ? $_REQUEST['order'] : 'asc'

        ));
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $this->columns = [
            $this->get_columns(),
            [], // hidden columns
            $this->get_sortable_columns(),
            $this->get_primary_column_name(),
        ];
        $_wp_column_headers[$screen->id] = $this->columns;
        $this->_column_headers = $this->columns;

        /* -- Fetch the items -- */
        $this->items = $wpdb->get_results($query);

    }

    /**
     * Display the rows of records in the table
     * @return string, echo the markup of the rows
     */
    function display_rows()
    {

        //Get the records registered in the prepare_items method
        $records = $this->items;
        list($columns, $hidden, $sortable, $primary) = $this->columns;
        //Get the columns registered in the get_columns and get_sortable_columns methods
        $empty_sign = '<span class="dashicons dashicons-minus"></span>';
        //Loop for each record
        if (!empty($records)) {
            foreach ($records as $idx => $data) {
                $user_id = $data->user_id;


                //Open the line
                echo '<tr id="record_' . $user_id . '">';
                foreach ($columns as $column_name => $column_display_name) {

                    //Style attributes for each col
                    $class = "class='$column_name column-$column_name'";
                    $style = "";
                    if (in_array($column_name, $hidden)) $style = ' style="display:none;"';
                    $attributes = $class . $style;

                    //edit link
                    $userlink = '/wp-admin/users.php?';

                    //Display the cell
                    switch ($column_name) {
                        case "col_user_id":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($user_id) ? $user_id : $empty_sign) . '</td>';
                            break;
//                        case "col_Id":
//                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->Id) ? $data->Id : $empty_sign) . '</td>';
//                            break;
                        case "col_Fname":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->Fname) ? $data->Fname : $empty_sign) . '</td>';
                            break;
                        case "col_Lname":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->Lname) ? $data->Lname : $empty_sign) . '</td>';
                            break;
                        case "col_NationalCode":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->NationalCode) ? $data->NationalCode : $empty_sign) . '</td>';
                            break;
                        case "col_Gender":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->Gender) ? ($data->Gender == 1 ? 'زن' : 'مرد') : $empty_sign) . '</td>';
                            break;
                        case "col_BornDate":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->BornDate) ? $data->BornDate : $empty_sign) . '</td>';
                            break;
                        case "col_PhoneNumber":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->PhoneNumber) ? $data->PhoneNumber : $empty_sign) . '</td>';
                            break;
                        case "col_CardNumber":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->CardNumber) ? $data->CardNumber : $empty_sign) . '</td>';
                            break;
                        case "col_Enabled":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->Enabled) && $data->Enabled ? '<span style="color:limegreen" class="dashicons dashicons-saved"></span>' : $empty_sign) . '</td>';
                            break;
                        case "col_score":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->score) ? floor($data->score / 10) : $empty_sign) . '</td>';
                            break;
                        case "col_purchaseVolume":
                            echo '<td ' . $attributes . '>' . stripslashes(isset($data->purchaseVolume) && is_numeric($data->purchaseVolume) ? number_format(floor(intval($data->purchaseVolume) / 10)) : $empty_sign) . '</td>';
                            break;
                        case "col_Actions":
                            echo '<td ' . $attributes . '>  </td>';
//                            echo '<td ' . $attributes . '> <form id="drclubs-actions-customer-' . $user_id . '-form" class="  " method="post"  data-url="' . admin_url('admin-ajax.php') . '" action="#"> <input type="hidden" name="user_id" value="' . $user_id . '"/><input type="hidden" name="action" value="drclubs_customer_actions"> <input style="background-color: red;color:white;border: none" type="submit" name="command" value="حذف" class="button "/>' . wp_nonce_field('drclubs_customer_actions', "drclubs-customer-{$user_id}-actions-nonce") . '<small class="">' . \DrClubs\Base\BaseController::includeLoader('echo') . '</small>' . '</form></td>';
                            break;
                    }
                }

                //Close the line
                echo '</tr>';
            }
        }
    }
}