<?php
/**
 * @package drclubs
 */

namespace DrClubs\Base;

use DrClubs\Api\Callbacks\AdminCallbacks;
use DrClubs\Api\Callbacks\CptCallbacks;
use DrClubs\Api\Callbacks\TaxCallbacks;
use DrClubs\Api\Callbacks\TestimonialCallbacks;
use  DrClubs\Base\BaseController;
use  DrClubs\Api\SettingsApi;
use DrClubs\Helper;

class  TemplateController extends BaseController
{

    public static $option_name = 'drclubs_plugin_templates';
    public $templates;

    public function register()
    {

        if (!$this->activated('templates_manager')) return;


        $this->templates = [
            'page-templates/two-columns-tpl.php' => 'دکتر کلابز دو ستونه'
        ];

        add_filter('theme_page_templates', [$this, 'custom_template']);
        add_filter('template_include', [$this, 'load_template']);

    }

    public function custom_template($templates)
    {
        $templates = array_merge($templates, $this->templates);
        return $templates;
    }

    public function load_template($template)
    {
        global $post;
        if (!$post) {
            return $template;
        }

        if (is_front_page()) {
            $file = $this->plugin_path . 'page-templates/front-page.php';
            if (file_exists($file))
                return $file;
        }

        $template_name = get_post_meta($post->ID, '_wp_page_template', true);


        if (!isset($this->templates[$template_name])) {
            return $template;
        }

        $file = $this->plugin_path . $template_name;

        if (file_exists($file))
            return $file;

        return $template;
    }
}